/*
ͻ
 NAME      : CONVERTC.C: CONVASC and CONVHEX routines.                       
 VERSION   : v 1.0                                                           
 FILE TYPE : Use TC.EXE to make the executable file...                       
 FUNCTION  : Shows how to use the ASCII <--> HEXA transcoding routines       
           : from the C language.                                            
           : Their main goal is to permit to a SERIAL PORTS MANAGER applic.  
           : using the Xon/Xoff protocol to transmit binary informations     
           : without any interferences with the soft hand-shaking...         
           : ATTENTION: Each binary code is associated to 2 ASCII codes.     
           : Therefore, the efficiency of an ASCII transmission is less      
           : than for a binary transmission ! ONLY USE THESE PROCEDURES      
           : IF YOU CAN NOT DO OTHERWISE...                                  
 SYNTAX    : CONVERTC                                                        
 COPYRIGHT : HETRU Fabrice 1991.                                             
ͼ
*/


#include "stdio.h" /* input/output  */
#include "dos.h"   /* using regs... */

union    REGS inregs,outregs;
struct   SREGS segregs;



void ConvAscii(unsigned char *pte, unsigned char *pts)
/* Converts 2 ASCII codes from *pte into *pts and *pts++...                */
  {
  unsigned char car,val;

  /* Stroring the hexa. number. */
  val = *pte;
  /* Converting the left half-byte */
  car = (val >> 4) + '0';
  *pts++ = car;
  /* Converting the right half-byte */
  car = (val & 0x0F) + '0';
  /* Returning the result */
  *pts = car;
  }


void ConvHexa(unsigned char *pte, unsigned char *pts)
/* Converts, into 1 HEXA, the 2 ASCII codes from *pte and *pte++ into *pts */
  {
  unsigned char car;

  /* Converting the left half-byte */
  car = (*pte++ - '0') << 4;
  /* Converting the right half-byte */
  car = car + (*pte - '0');
  /* Returning the result */
  *pts = car;
  }


int get_clav()
  {
  int l;

  inregs.h.ah = 0;
  int86(0x16,&inregs,&outregs);
  l = outregs.h.al;
  if (l==3) l = 67;
  return(l);
  }


main ()
  {
  char fin;
  char caract;
  unsigned int dest;
  unsigned char *pt;

  fin = 0;
  printf("CONVERTC: A demostration of the HEXA <--> ASCII trancoding.\n");
  printf("            (Press 'Esc' to end this program).\n");
  while(!fin)
    {
    /* Get the byte to transcode */
    printf("\nCharacter: ");
    caract = get_clav();
    if (caract!=0x0d)
      printf("%c/%x",caract,caract);
    else printf("  /%x",caract);
    if (caract==0x1b) fin = 1;

    /* HEXA-->ASCII transcoding */
    ConvAscii(&(char)caract,&(char)dest);
    /* Result into screen. */
    pt = &(char)dest + 1;
    printf(" --ConvAscii--> %c%c",(char)*pt,(char)dest);

    /* IN THAT POINT, THE ASCII BYTES MAY BE TRANSMITED WITHOUT ANY RISK
       TO INTERFER WITH THE Xon/Xoff HAND-SHAKING
       (whose codes are included between 0 and 29h...).
       INCONVENIENT from this method: For each byte to send, 2 bytes have
       to be transmited !... */

    /* ASCII-->HEXA transcoding */
    ConvHexa(&(char)dest,&(char)caract);
    /* Write the restitued byte into screen (=Primary code if O.K.) */
    if (caract!=0x0d)
      printf(" --ConvHexa--> %c/%x",caract,caract);
    else printf(" --ConvHexa-->   /%x",caract);
    }
  printf("\nCONVERTC has ended --- (C)HETRU Fabrice.\n");
  }
